# 画面設計書 42-kubectl api-resources

## 概要

本ドキュメントは、kubectlのapi-resourcesコマンドの画面設計書である。Kubernetes API ServerがサポートするAPIリソースタイプの一覧を表示するCLIコマンドの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：Kubernetesクラスタには多数のリソースタイプが存在し、カスタムリソース（CRD）の追加によりリソースタイプは動的に変化する。api-resourcesコマンドは、利用可能なリソースの名前、短縮名、APIグループ、名前空間スコープ、Kind名を確認するために使用される。マニフェスト作成やRBAC設計時にリソースタイプの正式名称を確認する用途で頻繁に利用される。

**画面へのアクセス方法**：ターミナルから `kubectl api-resources` を実行する。各種フィルタリングフラグを指定可能。

**主要な操作・処理内容**：
1. DiscoveryClientを通じてAPI Serverから推奨リソース一覧（ServerPreferredResources）を取得する
2. `--api-group`, `--namespaced`, `--verbs`, `--categories` フラグによるフィルタリングを適用する
3. `--sort-by` フラグ（name または kind）による並べ替えを行う
4. デフォルト出力では NAME, SHORTNAMES, APIVERSION, NAMESPACED, KIND の列を表示する
5. `--output wide` 指定時にはVERBS, CATEGORIESの列が追加される

**画面遷移**：CLIコマンドであるため画面遷移は存在しない。kubectlルートコマンドの「Other Commands」カテゴリに属する。

**権限による表示制御**：kubeconfigに設定されたユーザーの認証情報でAPI Serverにアクセスする。Discovery APIへのアクセス権限がない場合はエラーとなる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 109 | API Resources表示 | 主機能 | サポートされるAPIリソースタイプの一覧を表示する主処理 |
| 1 | API Serverコア | API連携 | APIリソース一覧取得のためAPI Serverにリクエストを送信する |

## 画面種別

一覧（CLIテーブル出力）

## URL/ルーティング

```
kubectl api-resources [flags]
```

## 入出力項目

### 入力項目（フラグ）

| 項目名 | 型 | 必須 | デフォルト | 説明 |
|--------|------|------|-----------|------|
| --api-group | string | 任意 | "" | 指定したAPIグループのリソースのみ表示する |
| --namespaced | bool | 任意 | true | trueでNamespacedリソース、falseでCluster-scopedリソースを表示 |
| --verbs | []string | 任意 | [] | 指定した動詞をサポートするリソースのみ表示 |
| --sort-by | string | 任意 | "" | ソートキー（"name" または "kind"）。空の場合はグループ名でソート |
| --cached | bool | 任意 | false | trueの場合キャッシュされたリソース一覧を使用する |
| --categories | []string | 任意 | [] | 指定カテゴリに属するリソースのみ表示 |
| --no-headers | bool | 任意 | false | ヘッダー行を非表示にする |
| -o, --output | string | 任意 | "" | 出力形式（"wide"で追加列を表示） |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|------|------|
| NAME | string | リソース名（複数形、例: pods） |
| SHORTNAMES | string | 短縮名（例: po） |
| APIVERSION | string | APIバージョン（例: v1, apps/v1） |
| NAMESPACED | bool | Namespace scopeかどうか |
| KIND | string | リソースのKind名（例: Pod） |
| VERBS | string | サポートする動詞一覧（wide出力時のみ） |
| CATEGORIES | string | 属するカテゴリ一覧（wide出力時のみ） |

## 表示項目

デフォルト出力例：
```
NAME                              SHORTNAMES   APIVERSION                        NAMESPACED   KIND
bindings                                       v1                                true         Binding
configmaps                        cm           v1                                true         ConfigMap
...
```

wide出力例（`-o wide`）：
```
NAME          SHORTNAMES   APIVERSION   NAMESPACED   KIND        VERBS                    CATEGORIES
configmaps    cm           v1           true         ConfigMap   create,delete,...
...
```

## イベント仕様

### 1-コマンド実行

1. `Complete` メソッドで引数チェック（引数ゼロ必須）、DiscoveryClient初期化、フラグ変更検知、プリンター初期化を実行
2. `Validate` メソッドで`--sort-by`の値が空、"name"、"kind"のいずれかであることを検証
3. `RunAPIResources` メソッドで：
   - `--cached` がfalseの場合、キャッシュを無効化
   - `ServerPreferredResources()` で推奨リソース一覧を取得
   - APIグループ、Namespace scope、動詞、カテゴリでフィルタリング
   - ソートを適用してTabWriter経由で出力

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| コマンド実行 | なし | SELECT（読取のみ） | API Serverからデータを取得するのみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 条件 |
|-------------|------|----------|------|
| ERR-01 | エラー | `--sort-by accepts only name or kind` | 不正なsort-by値指定時 |
| ERR-02 | エラー | `unexpected arguments: %v` | 引数が指定された場合 |

## 例外処理

- API Serverへの接続失敗時はDiscoveryClientのエラーが表示される
- ServerPreferredResources()が部分的に失敗した場合、取得できたリソースのみ表示される（部分エラー許容）
- フィルタリング結果が空の場合、出力なしで正常終了する

## 備考

- api-versionsコマンドと同一パッケージ内に実装されている
- ServerPreferredResources()はグループごとの推奨バージョンのリソースのみを返す
- Verbsが空のリソースはフィルタアウトされる（行204）
- ソートは安定ソート（sort.Stable）を使用している

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | apiresources.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiresources.go` | APIResourceOptions構造体（行64-80）のフィールドを理解する。SortBy、APIGroup、Namespaced、Verbs、Cached、Categoriesがフィルタ条件 |
| 1-2 | apiresources.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiresources.go` | sortableResource構造体（行263-290）がソートロジックを実装 |

**読解のコツ**: PrintFlagsは同パッケージ内の別ファイルで定義されている可能性がある。PrintObjはクロージャとして設定される点に注意。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | apiresources.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiresources.go` | NewCmdAPIResources関数（行92-116）がcobra.Commandを構築。各種フラグの登録処理に注目 |

**主要処理フロー**:
1. **行100-104**: Complete→Validate→RunAPIResourcesの順序で呼び出し
2. **行109-114**: 各フィルタリングフラグの登録

#### Step 3: 主処理ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | apiresources.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiresources.go` | RunAPIResources関数（行170-252）のフィルタリングロジック。行203-227のfor文でAPIグループ、Namespace、Verbs、Categoriesの各条件でフィルタリングする |

**主要処理フロー**:
- **行174-177**: キャッシュの無効化（--cached=falseの場合）
- **行180**: ServerPreferredResources()呼び出し
- **行187-229**: リソースのフィルタリング
- **行245**: 安定ソートの適用
- **行247**: PrintObj経由で出力

### プログラム呼び出し階層図

```
NewCmdAPIResources (apiresources.go:92)
    |
    +-- cobra.Command.Run
           |
           +-- Complete (apiresources.go:130)
           |       +-- restClientGetter.ToDiscoveryClient()
           |       +-- PrintFlags.ToPrinter()
           |
           +-- Validate (apiresources.go:119)
           |
           +-- RunAPIResources (apiresources.go:170)
                   +-- discoveryClient.Invalidate()
                   +-- discoveryClient.ServerPreferredResources()
                   +-- [フィルタリング処理]
                   +-- sort.Stable(sortableResource{...})
                   +-- PrintObj()
```

### データフロー図

```
[入力]               [処理]                    [出力]

フラグ ──────> DiscoveryClient ──────> TabWriter ──> stdout
(フィルタ条件)  .ServerPreferredResources()  (テーブル形式)
               フィルタリング
               ソート
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| apiresources.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiresources.go` | ソース | api-resourcesコマンド本体の実装 |
| apiversions.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiversions.go` | ソース | 同一パッケージ内のapi-versionsコマンド実装 |
| discovery_client.go | `staging/src/k8s.io/client-go/discovery/discovery_client.go` | ソース | DiscoveryClientインターフェースの実装 |
